<?php
/**
 * Class TravelPhysCheckout
 * @version 1.0.0
 * @author  physcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class TravelPhysWooPdfInvoicesPackingSlips {

	public static function init() {
		if ( is_plugin_active( 'woocommerce-pdf-invoices-packing-slips/woocommerce-pdf-invoices-packingslips.php' ) ) {
			add_action( 'wpo_wcpdf_after_item_meta', array( __CLASS__, 'show_info_tour_booking' ), 11, 3 );
		}
	}

	public static function show_info_tour_booking( $type, $item, $order ) {
		$item_id                 = $item['item_id'];
		$qty                     = wc_get_order_item_meta( $item_id, '_qty', true );
		$price_adults            = wc_get_order_item_meta( $item_id, '_price_adults', true );
		$number_children         = wc_get_order_item_meta( $item_id, '_number_children', true );
		$price_children          = wc_get_order_item_meta( $item_id, '_price_children', true );
		$currency                = get_woocommerce_currency_symbol( $order->get_currency() );
		$date_booking            = wc_get_order_item_meta( $item_id, '_date_booking', true );
		$date_tour_end           = wc_get_order_item_meta( $item_id, '_tour_date_end', true );
		$date_check_in           = wc_get_order_item_meta( $item_id, '_date_check_in', true );
		$date_check_out          = wc_get_order_item_meta( $item_id, '_date_check_out', true );
		$tour_variations         = wc_get_order_item_meta( $item_id, '_tour_variations', true );
		$tour_variations_options = wc_get_order_item_meta( $item_id, '_tour_variations_options', true );
		$is_tour                 = wc_get_order_item_meta( $item_id, '_is_tour', true ) !== '' ? wc_get_order_item_meta( $item_id, '_is_tour', true ) : false;

		if ( $is_tour ) {
			if ( $date_booking !== '' && $date_tour_end !== '' ) {
				echo '<div>' . __( 'Date check in', 'travel-booking' ) . ':&nbsp;' . $date_booking . '</div>';
				echo '<div>' . __( 'Date check out', 'travel-booking' ) . ':&nbsp;' . $date_tour_end . '</div>';
			}

			if ( $date_check_in !== '' && $date_check_out !== '' ) {
				echo '<div>' . __( 'Date check in', 'travel-booking' ) . ':&nbsp;' . $date_check_in . '</div>';
				echo '<div>' . __( 'Date check out', 'travel-booking' ) . ':&nbsp;' . $date_check_out . '</div>';
			}

			if ( isset( $price_adults ) && $price_adults !== '' ) {
				echo '<div>' . __( 'Adults', 'travel-booking' ) . '&nbsp;' . $currency . $price_adults . ' &times; ' . $qty . '</div>';
			}

			if ( isset( $number_children ) && $number_children !== '' ) {
				echo '<div>' . __( 'Children', 'travel-booking' ) . '&nbsp;' . $currency . $price_children . ' &times; ' . $number_children . '</div>';
			}

			/*** Variation ***/
			if ( isset( $tour_variations ) && is_object( $tour_variations ) && isset( $tour_variations_options ) && is_object( $tour_variations_options ) ) {
				if ( ! is_null( $tour_variations_options ) ) {
					TravelPhysVariation::view_variation_detail( $tour_variations, $tour_variations_options );
				}
			}
		}
	}
}

TravelPhysWooPdfInvoicesPackingSlips::init();
